IF NOT EXISTS (
		SELECT 1
		FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR
		GROUP BY [IDT_TRANSACAO], [CD_FILIAL]
		HAVING COUNT(1) > 1
)
BEGIN

	IF EXISTS (
			SELECT *
			FROM sys.indexes
			WHERE object_id = OBJECT_ID(N'[dbo].[CONCILIACAO_CARTOES_LINX_CONCILIADOR]')
				AND name = N'IX_UK_CONCILIACAO_CARTOES_LINX_CONCILIADOR_IDT_TRANSACAO'
			)
	BEGIN
		DROP INDEX [IX_UK_CONCILIACAO_CARTOES_LINX_CONCILIADOR_IDT_TRANSACAO] ON [dbo].[CONCILIACAO_CARTOES_LINX_CONCILIADOR]
	END


	CREATE UNIQUE NONCLUSTERED INDEX [IX_UK_CONCILIACAO_CARTOES_LINX_CONCILIADOR_IDT_TRANSACAO] ON [dbo].[CONCILIACAO_CARTOES_LINX_CONCILIADOR]
	(
		[IDT_TRANSACAO] ASC,
		[CD_FILIAL] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

END

